<?php

namespace Packlink\BusinessLogic\ShippingMethod\Interfaces;

use Packlink\BusinessLogic\ShippingMethod\Models\ShippingMethod;

/**
 * Interface ShopShippingMethodService. Must be implemented in integration.
 *
 * @package Packlink\BusinessLogic\ShippingMethod
 */
interface ShopShippingMethodService
{
    /**
     * Fully qualified name of this interface.
     */
    const CLASS_NAME = __CLASS__;

    /**
     * Adds / Activates shipping method in shop integration.
     *
     * @param ShippingMethod $shippingMethod Shipping method.
     *
     * @return bool TRUE if activation succeeded; otherwise, FALSE.
     */
    public function add(ShippingMethod $shippingMethod);

    /**
     * Updates shipping method in shop integration.
     *
     * @param ShippingMethod $shippingMethod Shipping method.
     */
    public function update(ShippingMethod $shippingMethod);

    /**
     * Deletes shipping method in shop integration.
     *
     * @param ShippingMethod $shippingMethod Shipping method.
     *
     * @return bool TRUE if deletion succeeded; otherwise, FALSE.
     */
    public function delete(ShippingMethod $shippingMethod);

    /**
     * Adds backup shipping method based on provided shipping method.
     *
     * @param ShippingMethod $shippingMethod
     *
     * @return bool TRUE if backup shipping method is added; otherwise, FALSE.
     */
    public function addBackupShippingMethod(ShippingMethod $shippingMethod);

    /**
     * Deletes backup shipping method.
     *
     * @return bool TRUE if backup shipping method is deleted; otherwise, FALSE.
     */
    public function deleteBackupShippingMethod();

    /**
     * Gets the carrier logo path based on carrier name.
     *
     * @param string $carrierName
     *
     * @return string
     */
    public function getCarrierLogoFilePath($carrierName);
}
