{*
* Copyright (c) 2023 Smartarget
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*
* @author    Smartarget
* @copyright 2023 Smartarget
* @license   https://opensource.org/licenses/MIT  MIT License
* Contact: support@smartarget.online
* Website: https://smartarget.online
*}
<!-- Load cdc library -->
<script src="https://assets.prestashop3.com/dst/mbo/v1/mbo-cdc-dependencies-resolver.umd.js"></script>

<!-- cdc container -->
<div id="cdc-container"></div>

<script defer>
	const renderMboCdcDependencyResolver = window.mboCdcDependencyResolver.render
	const context = {
		...{$dependencies|json_encode},
		onDependenciesResolved: () => location.reload(),
		onDependencyResolved: (dependencyData) => console.log('Dependency installed', dependencyData), // name, displayName, version
		onDependencyFailed: (dependencyData) => console.log('Failed to install dependency', dependencyData),
		onDependenciesFailed: () => console.log('There are some errors'),
	}
	renderMboCdcDependencyResolver(context, '#cdc-container')
</script>
